<?php

namespace RAP;

class MySQLJWKSDAO extends BaseMySQLDAO implements JWKSDAO {

    public function __construct($config) {
        parent::__construct($config);
    }

    public function insertRSAKeyPair(RSAKeyPair $keyPair): RSAKeyPair {

        $dbh = $this->getDBHandler();

        $query = "INSERT INTO rsa_keypairs(id, private_key, public_key, alg) VALUES (:id, :private_key, :public_key, :alg)";

        $stmt = $dbh->prepare($query);
        $stmt->bindParam(':id', $keyPair->keyId);
        $stmt->bindParam(':private_key', $keyPair->privateKey);
        $stmt->bindParam(':public_key', $keyPair->publicKey);
        $stmt->bindParam(':alg', $keyPair->alg);

        $stmt->execute();

        return $keyPair;
    }

    public function getRSAKeyPairs(): array {

        $dbh = $this->getDBHandler();

        $query = "SELECT id, private_key, public_key, alg, creation_time FROM rsa_keypairs";

        $stmt = $dbh->prepare($query);
        $stmt->execute();

        $keyPairs = [];
        foreach ($stmt->fetchAll() as $row) {
            $keyPair = $this->getRSAKeyPairFromResultRow($row);
            array_push($keyPairs, $keyPair);
        }

        return $keyPairs;
    }

    public function getRSAKeyPairById(string $id): ?RSAKeyPair {

        $dbh = $this->getDBHandler();

        $query = "SELECT id, private_key, public_key, alg, creation_time FROM rsa_keypairs WHERE id = :id";

        $stmt = $dbh->prepare($query);
        $stmt->bindParam(':id', $id);
        $stmt->execute();

        foreach ($stmt->fetchAll() as $row) {
            return $this->getRSAKeyPairFromResultRow($row);
        }

        return null;
    }

    public function getNewestKeyPair(): ?RSAKeyPair {
        $dbh = $this->getDBHandler();

        $query = "SELECT id, private_key, public_key, alg, creation_time FROM rsa_keypairs ORDER BY creation_time DESC LIMIT 1";

        $stmt = $dbh->prepare($query);
        $stmt->execute();

        foreach ($stmt->fetchAll() as $row) {
            return $this->getRSAKeyPairFromResultRow($row);
        }

        return null;
    }

    private function getRSAKeyPairFromResultRow(array $row): RSAKeyPair {
        $keyPair = new RSAKeyPair();
        $keyPair->keyId = $row['id'];
        $keyPair->privateKey = $row['private_key'];
        $keyPair->publicKey = $row['public_key'];
        $keyPair->alg = $row['alg'];
        $keyPair->creationTime = $row['creation_time'];
        return $keyPair;
    }

    public function getAllPublicJWK(): array {

        $dbh = $this->getDBHandler();

        $query = "SELECT `kid`, `key`, `url`, `update_time` FROM public_jwk";

        $stmt = $dbh->prepare($query);
        $stmt->execute();

        $keys = [];

        foreach ($stmt->fetchAll() as $row) {
            array_push($keys, $this->getPublicJWKFromResultRow($row));
        }

        return $keys;
    }

    private function getPublicJWKFromResultRow($row): PublicJWK {

        $jwk = new PublicJWK ();
        $jwk->key = $row['key'];
        $jwk->kid = $row['kid'];
        $jwk->url = $row['url'];
        $jwk->updateTime = $row['update_time'];
        return $jwk;
    }

    public function updatePublicJWK(PublicJWK $jwk) {

        $dbh = $this->getDBHandler();

        $query = "INSERT INTO public_jwk(kid, `key`, `url`, update_time) VALUES (:kid, :key, :url, :update_time)"
                . " ON DUPLICATE KEY UPDATE `key`=:key, `url`=:url, update_time=:update_time";

        $stmt = $dbh->prepare($query);
        $stmt->bindParam(':kid', $jwk->kid);
        $stmt->bindParam(':key', $jwk->key);
        $stmt->bindParam(':url', $jwk->url);
        $stmt->bindParam(':update_time', $jwk->updateTime);

        $stmt->execute();
    }

}
