<?php
include 'include/header.php';
?>

<br/>
<div class="text-center">
    <?php if ($autojoin) { ?>
        <h3>Multiple accounts detected</h3><br/>
        <p>The system found multiple accounts associated with the same e-mail address. We suggest you to join them, so that
            they will be seen as a single user. If you prefer to keep these accounts separated you can click on "Reject join" button.
        </p>
    <?php } else { ?>
        <h3>Following identities will be joined:</h3><br/>
    <?php } ?>
</div>

<div class="row">
    <div class="col-xs-12 col-md-6">
        <h4>User id: <?php echo $user->id; ?></h4>
        <div class="panel">
            <div class="panel-body">
                <?php
                $readOnly = true;
                include 'include/user-data.php';
                ?>        
            </div>
        </div>
    </div>
    <div class="col-xs-12 col-md-6">
        <h4><?php echo $user_to_join->id === null ? '&nbsp;' : ('User id: ' . $user_to_join->id); ?></h4>
        <div class="panel">
            <div class="panel-body">
                <?php
                $readOnly = true;
                $i = 0; // identity index
                foreach ($user_to_join->identities as $identity) {
                    include 'include/identities.php';
                    $i++;
                }
                ?>        
            </div>
        </div>
    </div>
</div>

<div class="text-center">
    <br/>
    <form action="confirm-join" method="POST">
        <input type="submit" value="Confirm join" class="btn btn-success btn-lg" />
    </form>
    <br/><br/><br/>
</div>

<?php
include 'include/footer.php';
