CREATE TABLE `oauth2_client` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `icon` varchar(255) DEFAULT NULL,
  `client` varchar(255) NOT NULL,
  `secret` varchar(255) NOT NULL,
  `redirect_url` text NOT NULL,
  `scope` varchar(255) DEFAULT NULL,
  `home_page` varchar(255) DEFAULT NULL,
  `show_in_home` tinyint(1) DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `oauth2_client_auth_methods` (
  `client_id` int NOT NULL,
  `auth_method` varchar(50) NOT NULL,
  PRIMARY KEY (`client_id`, `auth_method`),
  FOREIGN KEY (`client_id`) REFERENCES `oauth2_client`(`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `oauth2_client_scope_audience_mapping` (
  `client_id` int NOT NULL,
  `scope` varchar(255) NOT NULL,
  `audience` text NOT NULL,
  PRIMARY KEY (`client_id`, `scope`),
  FOREIGN KEY (`client_id`) REFERENCES `oauth2_client`(`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `cli_client` (
  `client_id` varchar(255) NOT NULL,
  `client_secret` varchar(255) NOT NULL,
  `scope` text,
  `audience` text,
  PRIMARY KEY (`client_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `user` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `primary_identity` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `identity` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) NOT NULL,
  `type` varchar(50) NOT NULL,
  `typed_id` varchar(255) NOT NULL,
  `email` varchar(255) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `surname` varchar(255) DEFAULT NULL,
  `institution` varchar(255) DEFAULT NULL,
  `eppn` varchar(255) DEFAULT NULL,
  `tou_accepted` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `last_login` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  FOREIGN KEY (`user_id`) REFERENCES `user`(`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
ALTER TABLE identity ADD CONSTRAINT eppn_unique UNIQUE(eppn);
ALTER TABLE identity ADD CONSTRAINT typed_id_unique UNIQUE(typed_id);

-- remember that a user decided to avoid a join
CREATE TABLE `keep_separated` (
  `user_id1` bigint(20) NOT NULL,
  `user_id2` bigint(20) NOT NULL,
  PRIMARY KEY (`user_id1`, `user_id2`),
  FOREIGN KEY (`user_id1`) REFERENCES `user`(`id`),
  FOREIGN KEY (`user_id2`) REFERENCES `user`(`id`)
);

SET FOREIGN_KEY_CHECKS=0;
ALTER TABLE `user` ADD FOREIGN KEY (`primary_identity`) REFERENCES `identity`(`id`);
SET FOREIGN_KEY_CHECKS=1;

CREATE TABLE `access_token` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(255) NOT NULL,
  `code_hash` varchar(255) DEFAULT NULL,
  `creation_time` bigint(20) NOT NULL,
  `expiration_time` bigint(20) DEFAULT NULL,
  `redirect_uri` text DEFAULT NULL,
  `client_id` varchar(255) DEFAULT NULL,
  `scope` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `refresh_token` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `token_hash` varchar(255) NOT NULL,
  `user_id` text NOT NULL,
  `creation_time` BIGINT NOT NULL,
  `expiration_time` BIGINT NOT NULL,
  `client_id` varchar(255) NOT NULL,
  `scope` text,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `rsa_keypairs` (
  `id` varchar(50) NOT NULL,
  `public_key` text,
  `private_key` text,
  `alg` varchar(255),
  `creation_time` BIGINT NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `public_jwk` (
  `kid` varchar(255) NOT NULL,
  `key` text,
  `url` text,
  `update_time` BIGINT NOT NULL,
  PRIMARY KEY (`kid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `rap_permissions` (
  `user_id` bigint NOT NULL,
  `permission` varchar(255) NOT NULL,
  PRIMARY KEY (`user_id`, `permission`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE EVENT login_tokens_cleanup
    ON SCHEDULE
      EVERY 1 MINUTE
    COMMENT 'Remove expired login tokens'
    DO
      DELETE FROM login_token WHERE CURRENT_TIMESTAMP > TIMESTAMPADD(MINUTE,1,creation_time);
