<?php

namespace RAP;

/**
 * Represents a client that connects to parts of RAP itself (e.g. Account Manager).
 * It doesn't use OAuth2, instead stores data directly into the PHP session.
 */
class InternalClient extends BrowserBasedClient {

    public $action;

    public function __construct(string $action) {
        $this->authMethods = AuthenticationMethods::getAllMethods();
        $this->action = $action;
    }

    public function getIconBasePath() {
        return 'service-logos/';
    }

}
