<?php

namespace RAP;

/**
 * RFC 6749 specify that in some situations the client must send an Authorization
 * Basic header containing its credentials (access token in the authorization code
 * flow and refresh token requests).
 */
class ClientAuthChecker {

    private $locator;

    public function __construct(Locator $locator) {
        $this->locator = $locator;
    }

    public function validateClientAuth(): void {

        $basic = $this->getBasicAuthArray();

        $clientId = $basic[0];
        $clientSecret = $basic[1];

        $this->locator->getBrowserBasedOAuth2ClientByIdAndSecret($clientId, $clientSecret);
    }

    public function validateCliClientAuth(): CliOAuth2Client {

        $basic = $this->getBasicAuthArray();

        $clientId = $basic[0];
        $clientSecret = $basic[1];

        return $this->locator->getCliClientByIdAndSecret($clientId, $clientSecret);
    }

    private function getBasicAuthArray(): array {
        $headers = apache_request_headers();

        if (!isset($headers['Authorization'])) {
            throw new UnauthorizedException("Missing Authorization header");
        }

        $authorizationHeader = explode(" ", $headers['Authorization']);
        if ($authorizationHeader[0] === "Basic") {
            $basic = explode(':', base64_decode($authorizationHeader[1]));
            if (count($basic) !== 2) {
                throw new BadRequestException("Malformed Basic-Auth header");
            }
            return $basic;
        } else {
            throw new UnauthorizedException("Expected Basic authorization header");
        }
    }

}
