/*
 * This file is part of gms
 * Copyright (C) 2021 Istituto Nazionale di Astrofisica
 * SPDX-License-Identifier: GPL-3.0-or-later
 */
package it.inaf.ia2.gms.manager;

import it.inaf.ia2.gms.authn.RapPrincipal;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.when;
import org.springframework.test.util.ReflectionTestUtils;

public class UserAwareComponentTestUtil {

    public static void setUser(UserAwareComponent component, String userId) {
        Map<String, Object> jwtClaims = new HashMap<>();
        jwtClaims.put("sub", userId);
        RapPrincipal principal = new RapPrincipal("token", jwtClaims);
        HttpServletRequest request = mock(HttpServletRequest.class);
        when(request.getUserPrincipal()).thenReturn(principal);
        ReflectionTestUtils.setField(component, "request", request);
    }
}
