/*
 * This file is part of gms
 * Copyright (C) 2021 Istituto Nazionale di Astrofisica
 * SPDX-License-Identifier: GPL-3.0-or-later
 */
package it.inaf.ia2.gms;

import it.inaf.ia2.gms.persistence.model.GroupEntity;
import it.inaf.ia2.gms.service.hook.GroupsHook;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class HooksConfig {

    @Bean
    public GroupsHook groupsHook() {
        return new GroupsHookTestImpl();
    }

    public static class GroupsHookTestImpl implements GroupsHook {

        @Override
        public void beforeCreate(GroupEntity group) {
        }

        @Override
        public void beforeUpdate(GroupEntity group) {
        }

        @Override
        public void beforeDelete(GroupEntity group) {
        }
    }
}
