/*
 * This file is part of gms
 * Copyright (C) 2021 Istituto Nazionale di Astrofisica
 * SPDX-License-Identifier: GPL-3.0-or-later
 */
package it.inaf.ia2.gms;

import java.security.Principal;
import javax.servlet.http.HttpServletRequest;
import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.when;

public class GmsTestUtils {

    public static void mockPrincipal(HttpServletRequest mockedServletRequest) {
        mockPrincipal(mockedServletRequest, "admin_id");
    }

    public static void mockPrincipal(HttpServletRequest mockedServletRequest, String userId) {
        Principal principal = mock(Principal.class);
        when(principal.getName()).thenReturn(userId);
        when(mockedServletRequest.getUserPrincipal()).thenReturn(principal);
    }
}
