/*
 * This file is part of gms
 * Copyright (C) 2021 Istituto Nazionale di Astrofisica
 * SPDX-License-Identifier: GPL-3.0-or-later
 */
package it.inaf.ia2.gms.model.request;

import javax.validation.constraints.NotEmpty;

public class AddGroupRequest extends PaginatedModelRequest implements SearchFilterRequest {

    @NotEmpty
    private String parentGroupId;
    @NotEmpty
    private String newGroupName;

    private boolean leaf;

    private String searchFilter;

    public String getNewGroupName() {
        return newGroupName;
    }

    public void setNewGroupName(String newGroupName) {
        this.newGroupName = newGroupName;
    }

    public String getParentGroupId() {
        return parentGroupId;
    }

    public void setParentGroupId(String parentGroupId) {
        this.parentGroupId = parentGroupId;
    }

    public boolean isLeaf() {
        return leaf;
    }

    public void setLeaf(boolean leaf) {
        this.leaf = leaf;
    }

    @Override
    public String getSearchFilter() {
        return searchFilter;
    }

    @Override
    public void setSearchFilter(String searchFilter) {
        this.searchFilter = searchFilter;
    }
}
