/*
 * This file is part of gms
 * Copyright (C) 2021 Istituto Nazionale di Astrofisica
 * SPDX-License-Identifier: GPL-3.0-or-later
 */
package it.inaf.ia2.gms.manager;

import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class UserAwareComponent {

    @Autowired
    private HttpServletRequest request;

    protected String getCurrentUserId() {
        return request.getUserPrincipal().getName();
    }
}
