package it.inaf.ia2.gms.service;

import it.inaf.ia2.gms.persistence.GroupsDAO;
import it.inaf.ia2.gms.persistence.model.GroupEntity;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import static org.junit.Assert.assertEquals;
import org.junit.Test;
import org.junit.runner.RunWith;
import static org.mockito.ArgumentMatchers.any;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import static org.mockito.Mockito.when;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(MockitoJUnitRunner.class)
public class GroupNameServiceTest {

    @Mock
    private GroupsDAO groupsDAO;

    @InjectMocks
    private GroupNameService groupNameService;

    @Test
    public void getNamesTest() {

        GroupEntity group = new GroupEntity();
        group.setName("Child\\.withDot");
        group.setId("def");
        group.setPath("abc.def");

        Set<GroupEntity> groups = new HashSet<>();
        groups.add(group);

        Map<String, String> daoResponse = new HashMap<>();
        daoResponse.put("def", "Parent_group.Child\\.withDot");

        when(groupsDAO.getGroupCompleteNamesFromId(any())).thenReturn(daoResponse);

        Map<String, List<String>> names = groupNameService.getNames(groups);
        assertEquals(1, names.size());
        assertEquals(2, names.get("def").size());
        assertEquals("Parent_group", names.get("def").get(0));
        assertEquals("Child\\.withDot", names.get("def").get(1));
    }

    @Test
    public void getRootTest() {

        Set<String> groupIds = new HashSet<>();
        groupIds.add("ROOT");

        when(groupsDAO.getGroupCompleteNamesFromId(any())).thenReturn(new HashMap<>());

        List<Map.Entry<String, String>> groupsIdPath = new ArrayList<>();
        groupsIdPath.add(new AbstractMap.SimpleEntry<>("ROOT", ""));

        Map<String, List<String>> names = groupNameService.getNamesFromIds(groupIds);
        assertEquals(1, names.size());
        assertEquals(1, names.get("ROOT").size());
        assertEquals("Root", names.get("ROOT").get(0));
    }
}
