package it.inaf.ia2.gms.client.call;

import it.inaf.ia2.client.BaseCall;
import it.inaf.ia2.gms.client.GmsClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse.BodyHandlers;

public class RemovePermissionCall extends BaseCall<GmsClient> {

    public RemovePermissionCall(GmsClient client) {
        super(client);
    }

    public boolean removePermission(String completeGroupName, String userId) {

        String endpoint = "ws/jwt/permission";
        if (completeGroupName != null && !completeGroupName.isBlank()) {
            endpoint += "/" + completeGroupName;
        }
        endpoint += "?user_id=" + userId;

        HttpRequest groupsRequest = client.newRequest(endpoint)
                .header("Accept", "text/plain")
                .DELETE()
                .build();

        return client.call(groupsRequest, BodyHandlers.ofInputStream(), 204, res -> true);
    }
}
