package it.inaf.ia2.gms.client.call;

import it.inaf.ia2.client.BaseCall;
import it.inaf.ia2.gms.client.GmsClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse.BodyHandlers;

public class DeleteGroupCall extends BaseCall<GmsClient> {

    public DeleteGroupCall(GmsClient client) {
        super(client);
    }

    public boolean deleteGroup(String completeGroupName) {

        HttpRequest groupsRequest = client.newRequest("ws/jwt/" + completeGroupName)
                .header("Accept", "text/plain")
                .DELETE()
                .build();

        return client.call(groupsRequest, BodyHandlers.ofInputStream(), 204, res -> true);
    }
}
