package it.inaf.ia2.gms.service;

import it.inaf.ia2.gms.model.Permission;
import it.inaf.ia2.gms.persistence.JoinDAO;
import it.inaf.ia2.gms.persistence.MembershipsDAO;
import it.inaf.ia2.gms.persistence.PermissionsDAO;
import it.inaf.ia2.gms.persistence.model.MembershipEntity;
import it.inaf.ia2.gms.persistence.model.PermissionEntity;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class JoinService {

    @Autowired
    private MembershipsDAO membershipsDAO;

    @Autowired
    private PermissionsDAO permissionsDAO;

    @Autowired
    private JoinDAO joinDAO;

    public void join(String userId1, String userId2) {

        Set<MembershipEntity> existingMemberships
                = membershipsDAO.getUserMemberships(userId1).stream()
                        .map(g -> getMembershipEntity(g.getId(), userId1))
                        .collect(Collectors.toSet());

        Set<MembershipEntity> membershipsToAdd
                = membershipsDAO.getUserMemberships(userId2).stream()
                        .map(g -> getMembershipEntity(g.getId(), userId1))
                        .filter(m -> !existingMemberships.contains(m))
                        .collect(Collectors.toSet());

        Set<PermissionEntity> existingPermissions
                = permissionsDAO.findUserPermissions(userId1).stream()
                        .collect(Collectors.toSet());

        Set<PermissionEntity> permissionsToAdd
                = permissionsDAO.findUserPermissions(userId2).stream()
                        .map(p -> {
                            p.setUserId(userId1);
                            return p;
                        })
                        .filter(p -> isPermissionToAdd(existingPermissions, p))
                        .collect(Collectors.toSet());

        joinDAO.join(membershipsToAdd, permissionsToAdd, userId2);
    }

    private MembershipEntity getMembershipEntity(String groupId, String userId) {
        MembershipEntity entity = new MembershipEntity();
        entity.setGroupId(groupId);
        entity.setUserId(userId);
        return entity;
    }

    private boolean isPermissionToAdd(Set<PermissionEntity> existingPermissions, PermissionEntity permissionToCheck) {
        for (PermissionEntity permission : existingPermissions) {
            if (permission.getGroupId().equals(permissionToCheck.getGroupId())
                    && permission.getUserId().equals(permissionToCheck.getUserId())) {
                if (permission.getPermission() == permissionToCheck.getPermission()) {
                    return false;
                }
                Permission strongerPermission = Permission.addPermission(
                        permission.getPermission(), permissionToCheck.getPermission());
                return permission.getPermission() != strongerPermission;
            }
        }
        return true;
    }
}
