package it.inaf.ia2.gms.client.call;

import it.inaf.ia2.gms.client.BaseGmsClientTest;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import static org.junit.jupiter.api.Assertions.assertEquals;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import static org.mockito.ArgumentMatchers.any;
import static org.mockito.Mockito.times;
import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(MockitoExtension.class)
public class GetUserGroupsTest extends BaseGmsClientTest {

    @BeforeEach
    @Override
    public void init() {
        super.init();
    }

    @Test
    public void testGetMyGroups() {

        String body = "LBT.INAF\n"
                + "LBT.AZ\n"
                + "";

        CompletableFuture response = CompletableFuture.completedFuture(getMockedStreamResponse(200, body));

        when(httpClient.sendAsync(any(), any())).thenReturn(response);
        List<String> groups = gmsClient.getMyGroups("LBT.");

        verify(httpClient, times(1)).sendAsync(endpointEq("GET", "search"), any());

        assertEquals(2, groups.size());
        assertEquals("INAF", groups.get(0));
        assertEquals("AZ", groups.get(1));
    }

    @Test
    public void testListGroups() {

        String body = "INAF\n"
                + "AZ";

        CompletableFuture response = CompletableFuture.completedFuture(getMockedStreamResponse(200, body));

        when(httpClient.sendAsync(any(), any())).thenReturn(response);
        List<String> groups = gmsClient.listGroups("LBT.");

        verify(httpClient, times(1)).sendAsync(endpointEq("GET", "list/LBT."), any());

        assertEquals(2, groups.size());
        assertEquals("INAF", groups.get(0));
        assertEquals("AZ", groups.get(1));
    }
}
