package it.inaf.ia2.gms.client.call;

import it.inaf.ia2.gms.client.BaseGmsClientTest;
import it.inaf.ia2.gms.client.model.Permission;
import java.util.concurrent.CompletableFuture;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import static org.mockito.ArgumentMatchers.any;
import static org.mockito.Mockito.times;
import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(MockitoExtension.class)
public class AddPermissionTest extends BaseGmsClientTest {

    @BeforeEach
    @Override
    public void init() {
        super.init();
    }

    @Test
    public void testAddPermission() {

        CompletableFuture response = CompletableFuture.completedFuture(getMockedResponse(200));

        when(httpClient.sendAsync(any(), any())).thenReturn(response);
        gmsClient.addPermission("LBT.INAF", "user", Permission.ADMIN);

        verify(httpClient, times(1)).sendAsync(endpointEq("POST", "permission/LBT.INAF"), any());
    }
}
