package it.inaf.ia2.gms.client.call;

import it.inaf.ia2.client.BaseCall;
import it.inaf.ia2.gms.client.GmsClient;
import it.inaf.ia2.gms.client.model.GroupPermission;
import it.inaf.ia2.gms.client.model.Permission;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse.BodyHandlers;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;

public class GetGroupPermissionsCall extends BaseCall<GmsClient> {

    public GetGroupPermissionsCall(GmsClient client) {
        super(client);
    }

    public List<GroupPermission> getGroupPermissions(String groupId) {

        List<GroupPermission> groupPermissions = new ArrayList<>();

        String endpoint = "permission";
        endpoint += "/" + groupId;

        HttpRequest groupsRequest = client.newRequest(endpoint)
                .header("Accept", "text/plain")
                .GET()
                .build();

        return client.call(groupsRequest, BodyHandlers.ofInputStream(), 200,
                inputStream -> {
                    try ( Scanner scan = new Scanner(inputStream)) {
                        while (scan.hasNextLine()) {
                            String line = scan.nextLine();
                            if (!line.isEmpty()) {
                                String[] split = line.split(" ");
                                GroupPermission groupPermission = new GroupPermission();
                                groupPermission.setUserId(split[0]);
                                groupPermission.setPermission(Permission.valueOf(split[1]));
                                groupPermissions.add(groupPermission);
                            }
                        }
                    }
                    return groupPermissions;
                });
    }
}
