package it.inaf.ia2.gms;

import it.inaf.ia2.aa.AuthConfig;
import it.inaf.ia2.aa.ServiceLocator;
import it.inaf.ia2.aa.UserManager;
import it.inaf.ia2.gms.authn.ServletRapClient;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@SpringBootApplication
@Configuration
@EnableTransactionManagement
public class GmsApplication {

    public static void main(String[] args) {
        SpringApplication.run(GmsApplication.class, args);
    }

    @Bean
    public AuthConfig authConfig() {
        return ServiceLocator.getInstance().getConfig();
    }

    @Bean
    public UserManager userManager() {
        return ServiceLocator.getInstance().getUserManager();
    }

    @Bean
    public ServletRapClient servletRapClient() {
        return (ServletRapClient) ServiceLocator.getInstance().getRapClient();
    }
}
