package it.inaf.ia2.gms.client.call;

import it.inaf.ia2.client.BaseCall;
import it.inaf.ia2.gms.client.GmsClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse.BodyHandlers;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;

public class GetUserGroupsCall extends BaseCall<GmsClient> {

    public GetUserGroupsCall(GmsClient client) {
        super(client);
    }

    /**
     * Returns the groups the user belongs to. If a groupsPrefix (parent group)
     * is specified, the prefix is removed from the list.
     */
    public List<String> getUserGroups(String prefix) {

        List<String> groups = new ArrayList<>();

        HttpRequest groupsRequest = client.newRequest("vo/search")
                .header("Accept", "text/plain")
                .GET()
                .build();

        return client.call(groupsRequest, BodyHandlers.ofInputStream(), 200,
                inputStream -> {
                    try ( Scanner scan = new Scanner(inputStream)) {
                        while (scan.hasNextLine()) {
                            String line = scan.nextLine();
                            if (!line.isEmpty()) {
                                if (prefix == null || prefix.isEmpty()) {
                                    groups.add(line);
                                } else {
                                    if (line.startsWith(prefix)) {
                                        line = line.substring(prefix.length());
                                        groups.add(line);
                                    }
                                }
                            }
                        }
                    }
                    return groups;
                });
    }

    public List<String> getUserGroups(String userId, String prefix) {

        List<String> groups = new ArrayList<>();

        String endpoint = "ws/jwt/membership";
        if (prefix != null && !prefix.isBlank()) {
            endpoint += "/" + prefix;
        }
        endpoint += "?user_id=" + userId;

        HttpRequest groupsRequest = client.newRequest(endpoint)
                .header("Accept", "text/plain")
                .GET()
                .build();

        return client.call(groupsRequest, BodyHandlers.ofInputStream(), 200,
                inputStream -> {
                    try ( Scanner scan = new Scanner(inputStream)) {
                        while (scan.hasNextLine()) {
                            String line = scan.nextLine();
                            if (!line.isEmpty()) {
                                groups.add(line);
                            }
                        }
                    }
                    return groups;
                });
    }
}
