package it.inaf.ia2.gms.client.call;

import it.inaf.ia2.client.BaseCall;
import it.inaf.ia2.gms.client.GmsClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.List;

public class GetGroupStatusCall extends BaseCall<GmsClient> {

    public GetGroupStatusCall(GmsClient client) {
        super(client);
    }

    public List<String[]> getStatus(String groupCompleteName) {

        String uri = "group/status?groupName=" + groupCompleteName;

        HttpRequest request = client.newRequest(uri)
                .header("Accept", "application/json")
                .GET()
                .build();

        return client.call(request, HttpResponse.BodyHandlers.ofInputStream(), 200,
                in -> parseJsonList(in, String[].class));
    }
}
