package it.inaf.ia2.gms.authn;

import it.inaf.ia2.aa.data.User;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.context.annotation.SessionScope;

@Component
@SessionScope
public class SessionData {

    private static final String USER_DATA = "user_data";

    private User user;

    @Autowired
    private HttpServletRequest request;

    @PostConstruct
    public void init() {
        HttpSession session = request.getSession(false);
        if (session != null && session.getAttribute(USER_DATA) != null) {
            setUser((User) session.getAttribute(USER_DATA));
        }
    }

    public void setUser(User user) {
        this.user = user;
    }

    public String getUserId() {
        return user.getName();
    }

    public String getUserName() {
        return user.getUserLabel();
    }

    public String getAccessToken() {
        return user.getAccessToken();
    }

    public String getRefreshToken() {
        return user.getRefreshToken();
    }

    public long getExpiresIn() {
        return user.getExpiresIn();
    }
}
