package it.inaf.ia2.gms.client.call;

import it.inaf.ia2.client.BaseCall;
import it.inaf.ia2.gms.client.GmsClient;
import it.inaf.ia2.gms.client.model.Permission;
import java.net.URLEncoder;
import java.net.http.HttpRequest;
import java.net.http.HttpRequest.BodyPublisher;
import java.net.http.HttpRequest.BodyPublishers;
import java.net.http.HttpResponse.BodyHandlers;
import java.nio.charset.StandardCharsets;

public class AddPermissionCall extends BaseCall<GmsClient> {

    public AddPermissionCall(GmsClient client) {
        super(client);
    }

    public String addPermission(String completeGroupName, String userId, Permission permission) {

        String endpoint = "permission";

        if (completeGroupName == null) {
            completeGroupName = "";
        }

        BodyPublisher requestBody = BodyPublishers.ofString(
                "group=" + URLEncoder.encode(completeGroupName, StandardCharsets.UTF_8)
                + "&user_id=" + userId + "&permission=" + permission);

        HttpRequest groupsRequest = client.newRequest(endpoint)
                .header("Accept", "text/plain")
                .header("Content-Type", "application/x-www-form-urlencoded")
                .POST(requestBody)
                .build();

        return client.call(groupsRequest, BodyHandlers.ofString(), 200, res -> res);
    }
}
