/* Vuex store, for centralized state management */

import Vue from 'vue';
import Vuex from 'vuex';
import client from 'api-client';

Vue.use(Vuex);

export default new Vuex.Store({
  state: {
    // values populated from API calls
    model: {
      breadcrumbs: [],
      groupsPanel: null,
      permissionsPanel: null,
      membersPanel: null,
      permission: null,
      user: null,
      genericSearchResults: [],
      userSearchResults: {
        userLabel: null,
        groups: {},
        permissions: {}
      }
    },
    // values used to perform API calls
    input: {
      selectedGroupId: 'ROOT',
      paginatorPageSize: 20,
      paginatorPage: 1,
      selectedTab: 'groups',
      tabIndex: 0,
      searchFilter: '',
      genericSearch: {
        filter: '',
        paginatorPage: 1,
        paginatorPageSize: 20
      }
    },
    loading: false,
    page: 'main'
  },
  mutations: {
    updateHomePageModel(state, model) {
      this.state.model.breadcrumbs = model.breadcrumbs;
      this.state.model.groupsPanel = model.groupsPanel;
      this.state.model.permission = model.permission;
      this.state.model.user = model.user;
    },
    openGroup(state, groupId) {
      let input = this.state.input;
      input.selectedGroupId = groupId;
      input.searchFilter = '';
      client.fetchGroupsTab(input)
        .then(model => {
          this.commit('updateGroups', model);
          if (model.groupsPanel.items.length > 0) {
            this.commit('setTabIndex', 0);
          } else {
            // If there are no subgroups show the members panel
            this.commit('setTabIndex', 1);
          }
          this.commit('showMainPage');
        });
    },
    updateGroups(state, model) {
      this.state.model.breadcrumbs = model.breadcrumbs;
      this.state.model.groupsPanel = model.groupsPanel;
      this.state.model.permission = model.permission;
    },
    updateGroupsPanel(state, groupsPanel) {
      this.state.model.groupsPanel = groupsPanel;
    },
    updatePermissionsPanel(state, permissionsPanel) {
      this.state.model.permissionsPanel = permissionsPanel;
    },
    updateMembersPanel(state, membersPanel) {
      this.state.model.membersPanel = membersPanel;
    },
    setTabIndex(state, tabIndex) {
      // this will trigger the tabChanged() method in Main.vue
      this.state.input.tabIndex = tabIndex;
    },
    setLoading(state, loading) {
      this.state.loading = loading;
    },
    showMainPage(state) {
      this.state.page = 'main';
    },
    displaySearchResults(state, results) {
      this.state.page = 'search';
      if (results) {
        this.state.model.genericSearchResults = results;
      }
    },
    updateSearchResults(state, results) {
      this.state.model.genericSearchResults = results;
    },
    displayUserSearchResults(state, data) {
      this.state.page = 'userSearch';
      this.state.model.userSearchResults.userLabel = data[0];
      this.state.model.userSearchResults.groups = data[1].groups;
      this.state.model.userSearchResults.permissions = data[1].permissions;
    }
  },
  getters: {
    selectedGroupId: state => {
      return state.model.breadcrumbs[state.model.breadcrumbs.length - 1].groupId;
    }
  }
});
