package it.inaf.ia2.gms.client.call;

import it.inaf.ia2.client.BaseCall;
import it.inaf.ia2.gms.client.GmsClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse.BodyHandlers;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;

public class ListGroupsCall extends BaseCall<GmsClient> {

    public ListGroupsCall(GmsClient client) {
        super(client);
    }

    /**
     * Returns the list of the groups in a given parent group (if the user has
     * the privileges to see that information). The prefix is removed by the
     * service.
     */
    public List<String> listGroups(String prefix) {

        List<String> groups = new ArrayList<>();

        String uri = "list";
        if (prefix != null && !prefix.isBlank()) {
            uri += "/" + prefix;
        }

        HttpRequest groupsRequest = client.newRequest(uri)
                .header("Accept", "text/plain")
                .GET()
                .build();

        return client.call(groupsRequest, BodyHandlers.ofInputStream(), 200,
                inputStream -> {
                    try ( Scanner scan = new Scanner(inputStream)) {
                        while (scan.hasNextLine()) {
                            String line = scan.nextLine();
                            if (!line.isEmpty()) {
                                groups.add(line);
                            }
                        }
                    }
                    return groups;
                });
    }
}
