package it.inaf.ia2.gms.service;

import it.inaf.ia2.gms.model.Permission;
import it.inaf.ia2.gms.model.RapUser;
import it.inaf.ia2.gms.model.UserPermission;
import it.inaf.ia2.gms.persistence.GroupsRepository;
import it.inaf.ia2.gms.persistence.PermissionsRepository;
import it.inaf.ia2.gms.persistence.UsersRepository;
import it.inaf.ia2.gms.persistence.model.Group;
import it.inaf.ia2.gms.persistence.model.User;
import it.inaf.ia2.gms.persistence.model.UserGroupPermission;
import it.inaf.ia2.gms.rap.RapClient;
import java.util.Collections;
import java.util.List;
import static org.junit.Assert.assertEquals;
import org.junit.Test;
import org.junit.runner.RunWith;
import static org.mockito.ArgumentMatchers.any;
import static org.mockito.Mockito.when;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.autoconfigure.jdbc.AutoConfigureTestDatabase;
import org.springframework.boot.test.autoconfigure.orm.jpa.DataJpaTest;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.test.context.junit4.SpringRunner;

@DataJpaTest
@AutoConfigureTestDatabase
@RunWith(SpringRunner.class)
public class PermissionsServiceIntegrationTest {

    private static final String USER_ID = "USER_ID";

    @Autowired
    private UsersRepository usersRepository;

    @Autowired
    private GroupsRepository groupsRepository;

    @Autowired
    private PermissionsRepository permissionsRepository;

    @MockBean
    private RapClient rapClient;

    @Test
    public void permissionsRetrievalTest() {

        // Mock RAP client
        RapUser rapUser = new RapUser();
        rapUser.setId(USER_ID);
        when(rapClient.getUsers(any())).thenReturn(Collections.singletonList(rapUser));

        PermissionsService permissionsService = new PermissionsService(permissionsRepository, rapClient);

        // Create user
        User user = new User();
        user.setId(USER_ID);
        user = usersRepository.save(user);

        Group root = new Group();
        root.setId(GroupsService.ROOT);
        root.setName(GroupsService.ROOT);
        root = groupsRepository.save(root);

        UserGroupPermission superAdminPermission = new UserGroupPermission();
        superAdminPermission.setUser(user);
        superAdminPermission.setGroup(root);
        superAdminPermission.setPermission(Permission.ADMIN);
        permissionsRepository.save(superAdminPermission);

        List<UserPermission> permissions = permissionsService.getUserPermissions(root);

        assertEquals(1, permissions.size());
        assertEquals(Permission.ADMIN, permissions.get(0).getPermission());
        assertEquals(USER_ID, permissions.get(0).getUser().getId());

        permissionsService.deletePermission(USER_ID, GroupsService.ROOT, Permission.ADMIN);
    }
}
