package it.inaf.ia2.gms.persistence;

import io.zonky.test.db.AutoConfigureEmbeddedDatabase;
import it.inaf.ia2.gms.model.Permission;
import it.inaf.ia2.gms.persistence.model.UserPermission;
import it.inaf.ia2.gms.persistence.model.NewGroup;
import java.util.List;
import javax.sql.DataSource;
import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.jdbc.Sql;
import org.springframework.test.context.junit4.SpringRunner;

@RunWith(SpringRunner.class)
@AutoConfigureEmbeddedDatabase(beanName = "dataSource")
public class PermissionsDAOTest {

    @Autowired
    private DataSource dataSource;

    private GroupsDAO groupsDAO;
    private PermissionsDAO permissionsDAO;

    @Before
    public void setUp() {
        groupsDAO = new GroupsDAO(dataSource);
        permissionsDAO = new PermissionsDAO(dataSource);
    }

    @Test
    @Sql("/sql/init.sql")
    public void testAll() {

        NewGroup root = new NewGroup();
        root.setId("ROOT");
        root.setName("ROOT");
        root.setPath("");
        groupsDAO.createGroup(root);

        String userId = "user_id";

        UserPermission permission = new UserPermission();
        permission.setGroupId(root.getId());
        permission.setUserId(userId);
        permission.setPermission(Permission.ADMIN);

        permissionsDAO.createPermission(permission);

        List<UserPermission> permissions = permissionsDAO.findUserPermissions(userId);

        assertEquals(1, permissions.size());
        assertEquals(Permission.ADMIN, permissions.get(0).getPermission());
        assertEquals(userId, permissions.get(0).getUserId());

        permissionsDAO.deletePermission(permission);

        permissions = permissionsDAO.findUserPermissions(userId);
        assertTrue(permissions.isEmpty());
    }
}
