package it.inaf.ia2.gms.persistence;

import com.google.common.collect.ImmutableSet;
import io.zonky.test.db.AutoConfigureEmbeddedDatabase;
import it.inaf.ia2.gms.persistence.model.NewGroup;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.sql.DataSource;
import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertTrue;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.jdbc.Sql;
import org.springframework.test.context.junit4.SpringRunner;

@RunWith(SpringRunner.class)
@AutoConfigureEmbeddedDatabase(beanName = "dataSource")
public class GroupsDAOTest {

    @Autowired
    private DataSource dataSource;

    private GroupsDAO dao;

    @Before
    public void setUp() {
        dao = new GroupsDAO(dataSource);
    }

    @Test
    @Sql("/sql/init.sql")
    public void testAll() {

        // Create groups
        NewGroup root = new NewGroup();
        root.setId("ROOT");
        root.setName("ROOT");
        root.setPath("");
        dao.createGroup(root);

        NewGroup lbt = new NewGroup();
        lbt.setId(getNewGroupId());
        lbt.setName("LBT");
        lbt.setPath(lbt.getId());
        dao.createGroup(lbt);

        NewGroup tng = new NewGroup();
        tng.setId(getNewGroupId());
        tng.setName("TNG");
        tng.setPath(tng.getId());
        dao.createGroup(tng);

        NewGroup lbtInaf = new NewGroup();
        lbtInaf.setId(getNewGroupId());
        lbtInaf.setName("INAF");
        lbtInaf.setPath(lbt.getId() + "." + lbtInaf.getId());
        dao.createGroup(lbtInaf);

        // Sub list
        List<NewGroup> groups = dao.listSubGroups("");
        assertEquals(2, groups.size());
        assertEquals("LBT", groups.get(0).getName());
        assertEquals("TNG", groups.get(1).getName());

        groups = dao.listSubGroups(lbt.getId());
        assertEquals(1, groups.size());
        assertEquals("INAF", groups.get(0).getName());
        
        // Children map
        Map<String, Boolean> childrenMap = dao.getHasChildrenMap(ImmutableSet.of(root.getId()));
        assertEquals(1, childrenMap.size());
        assertTrue(childrenMap.get(root.getId()));
        
        childrenMap = dao.getHasChildrenMap(ImmutableSet.of(lbt.getId(), tng.getId()));
        assertEquals(2, childrenMap.size());
        assertTrue(childrenMap.get(lbt.getId()));
        assertFalse(childrenMap.get(tng.getId()));

        // Delete
        dao.deleteGroupById(lbtInaf.getId());
        groups = dao.listSubGroups(lbt.getId());
        assertTrue(groups.isEmpty());
    }

    private String getNewGroupId() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }
}
