package it.inaf.ia2.gms.persistence.model;

import it.inaf.ia2.gms.model.Permission;
import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

/**
 * NOTE: underscores in variable names are used when a field is a reserved JPQL
 * keyword.
 */
@Entity
@IdClass(UserGroupPermissionId.class)
@Table(name = "gms_user_group_permission")
public class UserGroupPermission {

    @Id
    @ManyToOne
    @JoinColumn(name = "user_id", referencedColumnName = "id", columnDefinition = "varchar(50)")
    private User _user;

    @Id
    @ManyToOne
    @JoinColumn(name = "group_id", referencedColumnName = "id", columnDefinition = "varchar(50)")
    private Group _group;

    @Id
    @Enumerated(EnumType.STRING)
    @Column(name = "permission", length = 50)
    private Permission permission;

    public User getUser() {
        return _user;
    }

    public void setUser(User user) {
        this._user = user;
    }

    public Group getGroup() {
        return _group;
    }

    public void setGroup(Group group) {
        this._group = group;
    }

    public Permission getPermission() {
        return permission;
    }

    public void setPermission(Permission permission) {
        this.permission = permission;
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 47 * hash + Objects.hashCode(this._user);
        hash = 47 * hash + Objects.hashCode(this._group);
        hash = 47 * hash + Objects.hashCode(this.permission);
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        final UserGroupPermission other = (UserGroupPermission) obj;
        if (!Objects.equals(this._user, other._user)) {
            return false;
        }
        if (!Objects.equals(this._group, other._group)) {
            return false;
        }
        if (this.permission != other.permission) {
            return false;
        }
        return true;
    }
}
