package it.inaf.ia2.gms.persistence;

import it.inaf.ia2.gms.model.Permission;
import it.inaf.ia2.gms.persistence.model.Group;
import it.inaf.ia2.gms.persistence.model.User;
import it.inaf.ia2.gms.persistence.model.UserGroupPermission;
import it.inaf.ia2.gms.persistence.model.UserGroupPermissionId;
import java.util.List;
import java.util.Optional;
import javax.transaction.Transactional;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;

@Repository
@Transactional
public interface PermissionsRepository extends JpaRepository<UserGroupPermission, UserGroupPermissionId> {

    List<UserGroupPermission> findBy_user(User user);

    List<UserGroupPermission> findBy_group(Group group);

    @Query("SELECT u FROM UserGroupPermission u WHERE u._user.id = ?1 AND u._group.id = ?2 AND u.permission = ?3")
    Optional<UserGroupPermission> findPermission(String userId, String groupId, Permission permission);
}
