package it.inaf.ia2.gms.manager;

import it.inaf.ia2.gms.DataSourceConfig;
import it.inaf.ia2.gms.model.Permission;
import it.inaf.ia2.gms.model.RapUser;
import it.inaf.ia2.gms.model.UserPermission;
import it.inaf.ia2.gms.persistence.GroupsDAO;
import it.inaf.ia2.gms.persistence.LoggingDAO;
import it.inaf.ia2.gms.persistence.PermissionsDAO;
import it.inaf.ia2.gms.persistence.model.GroupEntity;
import it.inaf.ia2.gms.persistence.model.PermissionEntity;
import it.inaf.ia2.gms.rap.RapClient;
import it.inaf.ia2.gms.service.PermissionsService;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.sql.DataSource;
import static org.junit.Assert.assertEquals;
import org.junit.Test;
import org.junit.runner.RunWith;
import static org.mockito.ArgumentMatchers.any;
import static org.mockito.Mockito.when;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringRunner;

@RunWith(SpringRunner.class)
@ContextConfiguration(classes = DataSourceConfig.class)
public class PermissionsManagerIntegrationTest {

    private static final String USER_ID = "USER_ID";

    @MockBean
    private RapClient rapClient;

    @MockBean
    private LoggingDAO loggingDAO;

    @Autowired
    private DataSource dataSource;

    @MockBean
    private HttpServletRequest request;

    @Test
    public void permissionsRetrievalTest() {

        GroupsDAO groupsDAO = new GroupsDAO(dataSource);
        PermissionsDAO permissionsDAO = new PermissionsDAO(dataSource);

        // Mock RAP client
        RapUser rapUser = new RapUser();
        rapUser.setId(USER_ID);
        when(rapClient.getUsers(any())).thenReturn(Collections.singletonList(rapUser));

        PermissionsService permissionsService = new PermissionsService(permissionsDAO, loggingDAO);
        PermissionsManager permissionsManager = new PermissionsManager(permissionsService, rapClient, loggingDAO);
        UserAwareComponentTestUtil.setUser(permissionsManager, USER_ID);

        // Create root
        GroupEntity root = new GroupEntity();
        root.setId("ROOT");
        root.setName("Root");
        root.setPath("");
        root = groupsDAO.createGroup(root);

        PermissionEntity superAdminPermission = new PermissionEntity();
        superAdminPermission.setUserId(USER_ID);
        superAdminPermission.setGroupId(root.getId());
        superAdminPermission.setPermission(Permission.ADMIN);
        superAdminPermission.setGroupPath(root.getPath());
        permissionsDAO.createOrUpdatePermission(superAdminPermission);

        List<UserPermission> permissions = permissionsManager.getAllPermissions(root);

        assertEquals(1, permissions.size());
        assertEquals(Permission.ADMIN, permissions.get(0).getPermission());
        assertEquals(USER_ID, permissions.get(0).getUser().getId());

        permissionsManager.removePermission(root, USER_ID);
    }
}
