package it.inaf.ia2.gms.authn;

import java.util.ArrayList;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import static org.junit.Assert.assertTrue;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.when;
import org.mockito.junit.MockitoJUnitRunner;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.provider.OAuth2Authentication;

@RunWith(MockitoJUnitRunner.class)
public class SessionDataTest {

    @Mock
    private HttpServletRequest request;

    @InjectMocks
    private SessionData sessionData;

    @Test
    public void testExpired() {

        OAuth2AccessToken accessToken = mock(OAuth2AccessToken.class);
        when(accessToken.getExpiresIn()).thenReturn(3600);

        CustomAuthenticationData data = new CustomAuthenticationData("user",
                new HashMap<>(), new ArrayList<>(), accessToken, "refresh_token");

        OAuth2Authentication auth = mock(OAuth2Authentication.class);
        when(auth.getUserAuthentication()).thenReturn(data);
        when(request.getUserPrincipal()).thenReturn(auth);

        sessionData.init();

        assertTrue(sessionData.getExpiresIn() > 0);
    }
}
