package it.inaf.ia2.gms.authn;

import it.inaf.ia2.gms.persistence.LoggingDAO;
import java.util.List;
import java.util.Map;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.provider.token.DefaultUserAuthenticationConverter;
import org.springframework.security.oauth2.provider.token.store.jwk.JwkTokenStore;

public class CustomIdTokenConverter extends DefaultUserAuthenticationConverter {

    private final JwkTokenStore jwkTokenStore;
    private final LoggingDAO loggingDAO;

    public CustomIdTokenConverter(JwkTokenStore jwkTokenStore, LoggingDAO loggingDAO) {
        this.jwkTokenStore = jwkTokenStore;
        this.loggingDAO = loggingDAO;
    }

    @Override
    public Authentication extractAuthentication(Map<String, ?> map) {

        String idTokenString = (String) map.get("id_token");
        String accessTokenString = (String) map.get("access_token");

        OAuth2AccessToken token = jwkTokenStore.readAccessToken(idTokenString);
        OAuth2AccessToken accessToken = jwkTokenStore.readAccessToken(accessTokenString);
        String refreshToken = (String) map.get("refresh_token");

        Map<String, Object> claims = token.getAdditionalInformation();

        String principal = (String) claims.get("sub");
        loggingDAO.logAction("Login by " + principal);

        List<GrantedAuthority> authorities = AuthorityUtils.createAuthorityList("ROLE_USER");

        return new CustomAuthenticationData(principal, claims, authorities, accessToken, refreshToken);
    }
}
