package it.inaf.ia2.gms.client.call;

import static it.inaf.ia2.gms.client.call.BaseGmsCall.logServerErrorInputStream;
import it.inaf.ia2.gms.client.model.Permission;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;

public class SetPermissionCall extends BaseGmsCall {

    public SetPermissionCall(HttpClientWrapper clientWrapper) {
        super(clientWrapper);
    }

    public boolean setPermission(String completeGroupName, String userId, Permission permission) {

        String endpoint = "permission";
        if (completeGroupName != null && !completeGroupName.isBlank()) {
            endpoint += "/" + completeGroupName;
        }

        HttpRequest.BodyPublisher requestBody = HttpRequest.BodyPublishers.ofString(
                "user_id=" + userId + "&permission=" + permission);

        HttpRequest groupsRequest = newHttpRequest(endpoint)
                .header("Accept", "text/plain")
                .header("Content-Type", "application/x-www-form-urlencoded")
                .PUT(requestBody)
                .build();

        return getClient().sendAsync(groupsRequest, HttpResponse.BodyHandlers.ofInputStream())
                .thenApply(response -> {
                    if (response.statusCode() == 200) {
                        return true;
                    }
                    logServerErrorInputStream(groupsRequest, response);
                    throw new IllegalStateException("Unable to set permission");
                }).join();
    }
}
