package it.inaf.ia2.gms.client.call;

import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;

public class GetUserGroupsCall extends BaseGmsCall {

    public GetUserGroupsCall(HttpClientWrapper clientWrapper) {
        super(clientWrapper);
    }

    /**
     * Returns the groups the user belongs to. If a groupsPrefix (parent group)
     * is specified, the prefix is removed from the list.
     */
    public List<String> getUserGroups(String prefix) {

        List<String> groups = new ArrayList<>();

        HttpRequest groupsRequest = newHttpRequest("search")
                .header("Accept", "text/plain")
                .GET()
                .build();

        return getClient().sendAsync(groupsRequest, HttpResponse.BodyHandlers.ofInputStream())
                .thenApply(response -> {
                    if (response.statusCode() == 200) {
                        return response.body();
                    }
                    logServerErrorInputStream(groupsRequest, response);
                    throw new IllegalStateException("Unable to retrieve groups");
                })
                .thenApply(inputStream -> {
                    try (Scanner scan = new Scanner(inputStream)) {
                        while (scan.hasNextLine()) {
                            String line = scan.nextLine();
                            if (!line.isEmpty()) {
                                if (prefix == null || prefix.isEmpty()) {
                                    groups.add(line);
                                } else {
                                    if (line.startsWith(prefix)) {
                                        line = line.substring(prefix.length());
                                        groups.add(line);
                                    }
                                }
                            }
                        }
                    }
                    return groups;
                }).join();
    }

    public List<String> getUserGroups(String userId, String prefix) {

        List<String> groups = new ArrayList<>();

        String endpoint = "membership";
        if (prefix != null && !prefix.isBlank()) {
            endpoint += "/" + prefix;
        }
        endpoint += "?user_id=" + userId;

        HttpRequest groupsRequest = newHttpRequest(endpoint)
                .header("Accept", "text/plain")
                .GET()
                .build();

        return getClient().sendAsync(groupsRequest, HttpResponse.BodyHandlers.ofInputStream())
                .thenApply(response -> {
                    if (response.statusCode() == 200) {
                        return response.body();
                    }
                    logServerErrorInputStream(groupsRequest, response);
                    throw new IllegalStateException("Unable to retrieve groups");
                })
                .thenApply(inputStream -> {
                    try (Scanner scan = new Scanner(inputStream)) {
                        while (scan.hasNextLine()) {
                            String line = scan.nextLine();
                            if (!line.isEmpty()) {
                                groups.add(line);
                            }
                        }
                    }
                    return groups;
                }).join();
    }
}
