package it.inaf.ia2.gms.client.call;

import java.io.InputStream;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpRequest.Builder;
import java.net.http.HttpResponse;
import java.util.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseGmsCall {

    private static final Logger LOGGER = LoggerFactory.getLogger(BaseGmsCall.class);

    protected final HttpClientWrapper clientWrapper;

    public BaseGmsCall(HttpClientWrapper clientWrapper) {
        this.clientWrapper = clientWrapper;
    }

    protected HttpClient getClient() {
        return clientWrapper.getClient();
    }

    protected Builder newHttpRequest(String endpoint) {
        return clientWrapper.newHttpRequest(endpoint);
    }

    protected static void logServerError(HttpRequest request, HttpResponse<String> response) {
        LOGGER.error("Error while reading " + request.uri()
                + "\nServer response status code is " + response.statusCode()
                + "\nServer response text is " + response.body());
    }

    protected static void logServerErrorInputStream(HttpRequest request, HttpResponse<InputStream> response) {
        Scanner s = new Scanner(response.body()).useDelimiter("\\A");
        String responseBody = s.hasNext() ? s.next() : "";
        String error = "Error while reading " + request.uri()
                + "\nServer response status code is " + response.statusCode()
                + "\nServer response text is " + responseBody;
        LOGGER.error(error);
    }
}
