package it.inaf.ia2.gms.client.call;

import java.net.http.HttpRequest;
import java.net.http.HttpRequest.BodyPublishers;
import java.net.http.HttpResponse;

public class CreateGroupCall extends BaseGmsCall {

    public CreateGroupCall(HttpClientWrapper clientWrapper) {
        super(clientWrapper);
    }

    public boolean createGroup(String completeGroupName, boolean leaf) {

        HttpRequest groupsRequest = newHttpRequest(completeGroupName)
                .header("Accept", "text/plain")
                .POST(BodyPublishers.ofString("leaf=" + leaf))
                .build();

        return getClient().sendAsync(groupsRequest, HttpResponse.BodyHandlers.ofInputStream())
                .thenApply(response -> {
                    if (response.statusCode() == 201) {
                        return true;
                    }
                    logServerErrorInputStream(groupsRequest, response);
                    throw new IllegalStateException("Unable to create group");
                }).join();
    }
}
