package it.inaf.ia2.gms.client;

import it.inaf.ia2.gms.client.call.HttpClientWrapper;
import it.inaf.ia2.gms.client.call.AddMemberCall;
import it.inaf.ia2.gms.client.call.AddPermissionCall;
import it.inaf.ia2.gms.client.call.CreateGroupCall;
import it.inaf.ia2.gms.client.call.DeleteGroupCall;
import it.inaf.ia2.gms.client.call.GetUserGroupsCall;
import it.inaf.ia2.gms.client.call.GetUserPermissionsCall;
import it.inaf.ia2.gms.client.call.ListGroupsCall;
import it.inaf.ia2.gms.client.call.RemoveMemberCall;
import it.inaf.ia2.gms.client.call.RemovePermissionCall;
import it.inaf.ia2.gms.client.model.Permission;
import it.inaf.ia2.gms.client.model.UserPermission;
import java.util.List;

public class GmsClient {

    HttpClientWrapper httpClientWrapper;

    public GmsClient(String baseUrl) {

        if (!baseUrl.endsWith("/")) {
            baseUrl += "/";
        }

        httpClientWrapper = new HttpClientWrapper(baseUrl);
    }

    public GmsClient setAccessToken(String accessToken) {
        httpClientWrapper.setAccessToken(accessToken);
        return this;
    }

    public List<String> getMyGroups(String prefix) {
        return new GetUserGroupsCall(httpClientWrapper).getUserGroups(prefix);
    }

    public List<String> listGroups(String prefix) {
        return new ListGroupsCall(httpClientWrapper).listGroups(prefix);
    }

    public List<String> getUserGroups(String userId, String prefix) {
        return new GetUserGroupsCall(httpClientWrapper).getUserGroups(userId, prefix);
    }

    public void createGroup(String completeGroupName, boolean leaf) {
        new CreateGroupCall(httpClientWrapper).createGroup(completeGroupName, leaf);
    }

    public void deleteGroup(String completeGroupName) {
        new DeleteGroupCall(httpClientWrapper).deleteGroup(completeGroupName);
    }

    public void addMember(String completeGroupName, String userId) {
        new AddMemberCall(httpClientWrapper).addMember(completeGroupName, userId);
    }

    public void removeMember(String completeGroupName, String userId) {
        new RemoveMemberCall(httpClientWrapper).removeMember(completeGroupName, userId);
    }

    public void addPermission(String completeGroupName, String userId, Permission permission) {
        new AddPermissionCall(httpClientWrapper).addPermission(completeGroupName, userId, permission);
    }

    public void removePermission(String completeGroupName, String userId) {
        new RemovePermissionCall(httpClientWrapper).removePermission(completeGroupName, userId);
    }

    public List<UserPermission> getUserPermissions(String userId) {
        return new GetUserPermissionsCall(httpClientWrapper).getUserPermissions(userId);
    }
}
