package it.inaf.ia2.gms.client.call;

import java.io.InputStream;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpRequest.Builder;
import java.net.http.HttpResponse;
import java.util.Scanner;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class BaseGmsCall {

    private static final Logger LOGGER = Logger.getLogger(BaseGmsCall.class.getName());

    protected final HttpClientWrapper clientWrapper;

    public BaseGmsCall(HttpClientWrapper clientWrapper) {
        this.clientWrapper = clientWrapper;
    }

    protected HttpClient getClient() {
        return clientWrapper.getClient();
    }

    protected Builder newHttpRequest(String endpoint) {
        return clientWrapper.newHttpRequest(endpoint);
    }

    protected void logServerError(HttpRequest request, HttpResponse<String> response) {
        LOGGER.log(Level.SEVERE, () -> "Error while reading " + request.uri()
                + "\nServer response status code is " + response.statusCode()
                + "\nAServer response text is " + response.body());
    }

    protected void logServerErrorInputStream(HttpRequest request, HttpResponse<InputStream> response) {
        LOGGER.log(Level.SEVERE, () -> {
            Scanner s = new Scanner(response.body()).useDelimiter("\\A");
            String responseBody = s.hasNext() ? s.next() : "";
            return "Error while reading " + request.uri()
                    + "\nServer response status code is " + response.statusCode()
                    + "\nServer response text is " + responseBody;
        });
    }
}
