import '@babel/polyfill'
import 'mutationobserver-shim'
import Vue from 'vue'
import store from './store.js'
import './plugins/bootstrap-vue'
import App from './App.vue'
import { library } from '@fortawesome/fontawesome-svg-core'
import { faTrash, faEdit, faSpinner, faFolder, faUser, faSave } from '@fortawesome/free-solid-svg-icons'
import { FontAwesomeIcon } from '@fortawesome/vue-fontawesome'

import VueRouter from 'vue-router'
Vue.use(VueRouter)
import router from './router.js';

library.add(faTrash, faEdit, faSpinner, faFolder, faUser, faSave);

Vue.component('font-awesome-icon', FontAwesomeIcon);

Vue.config.productionTip = false;

new Vue({
  render: h => h(App),
  store,
  router
}).$mount('#app');
