package it.inaf.ia2.gms.client.call;

import java.net.http.HttpRequest;
import java.net.http.HttpResponse;

public class RemovePermissionCall extends BaseGmsCall {

    public RemovePermissionCall(HttpClientWrapper clientWrapper) {
        super(clientWrapper);
    }

    public boolean removePermission(String completeGroupName, String userId) {

        String endpoint = "permission";
        if (completeGroupName != null && !completeGroupName.isBlank()) {
            endpoint += "/" + completeGroupName;
        }
        endpoint += "?user_id=" + userId;

        HttpRequest groupsRequest = newHttpRequest(endpoint)
                .header("Accept", "text/plain")
                .DELETE()
                .build();

        return getClient().sendAsync(groupsRequest, HttpResponse.BodyHandlers.ofInputStream())
                .thenApply(response -> {
                    if (response.statusCode() == 204) {
                        return true;
                    }
                    logServerErrorInputStream(groupsRequest, response);
                    throw new IllegalStateException("Unable to remove permission");
                }).join();
    }

}
