package it.inaf.ia2.gms.authn;

import java.util.List;
import java.util.Map;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.provider.token.DefaultUserAuthenticationConverter;
import org.springframework.security.oauth2.provider.token.store.jwk.JwkTokenStore;

public class CustomIdTokenConverter extends DefaultUserAuthenticationConverter {

    private final JwkTokenStore jwkTokenStore;

    public CustomIdTokenConverter(JwkTokenStore jwkTokenStore) {
        this.jwkTokenStore = jwkTokenStore;
    }

    @Override
    public Authentication extractAuthentication(Map<String, ?> map) {

        String idToken = (String) map.get("id_token");

        OAuth2AccessToken token = jwkTokenStore.readAccessToken(idToken);

        String refreshToken = (String) map.get("refresh_token");

        Map<String, Object> claims = token.getAdditionalInformation();

        String principal = (String) claims.get("sub");

        List<GrantedAuthority> authorities = AuthorityUtils.createAuthorityList("ROLE_USER");

        return new CustomAuthenticationData(principal, claims, authorities, token, refreshToken);
    }
}
