package it.inaf.ia2.gms.authn;

import it.inaf.ia2.aa.data.User;
import it.inaf.ia2.rap.client.RapClient;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import static org.junit.Assert.assertTrue;
import org.junit.Test;
import org.junit.runner.RunWith;
import static org.mockito.ArgumentMatchers.eq;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.when;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(MockitoJUnitRunner.class)
public class SessionDataTest {

    @Mock
    private HttpServletRequest request;
    
    @Mock
    private RapClient rapClient;

    @InjectMocks
    private SessionData sessionData;

    @Test
    public void testExpired() {

        HttpSession session = mock(HttpSession.class);
        when(request.getSession(eq(false))).thenReturn(session);

        User user = new User()
                .setUserId("123")
                .setUserLabel("Name Surname")
                .setAccessToken("<access_token>")
                .setRefreshToken("<refresh_token>")
                .setExpiresIn(3600);

        when(session.getAttribute(eq("user_data"))).thenReturn(user);

        sessionData.init();

        assertTrue(sessionData.getExpiresIn() > 0);
    }
}
