package it.inaf.ia2.gms.client.call;

import it.inaf.ia2.gms.client.BaseGmsClientTest;
import java.util.concurrent.CompletableFuture;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import static org.mockito.ArgumentMatchers.any;
import static org.mockito.Mockito.times;
import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(MockitoExtension.class)
public class RemoveMemberTest extends BaseGmsClientTest {

    @BeforeEach
    @Override
    public void init() {
        super.init();
    }

    @Test
    public void testRemoveMember() {

        CompletableFuture response = CompletableFuture.completedFuture(getMockedResponse(204));

        when(httpClient.sendAsync(any(), any())).thenReturn(response);
        gmsClient.removeMember("LBT.INAF", "user");

        verify(httpClient, times(1)).sendAsync(endpointEq("DELETE", "ws/jwt/membership/LBT.INAF?user_id=user"), any());
    }
}
