package it.inaf.ia2.gms.client.call;

import it.inaf.ia2.gms.client.model.Permission;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;

public class GetMemberEmailAddresses extends BaseGmsCall {

    public GetMemberEmailAddresses(HttpClientWrapper clientWrapper) {
        super(clientWrapper);
    }

    public List<String> getMemberEmailAddresses(String group, Permission permission) {

        List<String> emailAddresses = new ArrayList<>();

        String endpoint = "email/" + group;
        if (permission != null) {
            endpoint += "?permission=" + permission;
        }

        HttpRequest request = newHttpRequest(endpoint)
                .header("Accept", "text/plain")
                .GET()
                .build();

        return getClient().sendAsync(request, HttpResponse.BodyHandlers.ofInputStream())
                .thenApply(response -> {
                    if (response.statusCode() == 200) {
                        return response.body();
                    }
                    logServerErrorInputStream(request, response);
                    throw new IllegalStateException("Unable to retrieve groups");
                })
                .thenApply(inputStream -> {
                    try (Scanner scan = new Scanner(inputStream)) {
                        while (scan.hasNextLine()) {
                            String line = scan.nextLine();
                            if (!line.isEmpty()) {
                                emailAddresses.add(line);
                            }
                        }
                    }
                    return emailAddresses;
                }).join();
    }
}
