package it.inaf.ia2.gms.client;

import it.inaf.ia2.gms.client.call.HttpClientWrapper;

public class GmsClientBuilder {

    private String gmsBaseUrl;
    private String rapBaseUrl;
    private String clientId;
    private String clientSecret;

    public GmsClientBuilder setGmsBaseUrl(String gmsBaseUrl) {
        this.gmsBaseUrl = gmsBaseUrl;
        return this;
    }

    public GmsClientBuilder setRapBaseUrl(String rapBaseUrl) {
        this.rapBaseUrl = rapBaseUrl;
        return this;
    }

    public GmsClientBuilder setClientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    public GmsClientBuilder setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
        return this;
    }

    public GmsClient build() {
        HttpClientWrapper clientWrapper = new HttpClientWrapper(gmsBaseUrl);
        if (rapBaseUrl != null && clientId != null && clientSecret != null) {
            clientWrapper.setRapBaseUrl(rapBaseUrl)
                    .setClientId(clientId).setClientSecret(clientSecret);
        }
        return new GmsClient(clientWrapper);
    }
}
