package it.inaf.ia2.gms.authn;

import it.inaf.ia2.aa.AuthConfig;
import it.inaf.ia2.rap.client.RapClient;
import java.io.IOException;
import java.net.URI;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

public class ClientDbFilter implements Filter {

    public static final String CLIENT_DB = "client_db";

    private final RapClient rapClient;
    private final String defaultJwksUri;

    public ClientDbFilter(AuthConfig authConfig, RapClient rapClient) {
        this.rapClient = rapClient;
        defaultJwksUri = URI.create(authConfig.getRapBaseUri()).resolve(authConfig.getJwksEndpoint()).toString();
    }

    @Override
    public void doFilter(ServletRequest req, ServletResponse res, FilterChain fc) throws IOException, ServletException {

        HttpServletRequest request = (HttpServletRequest) req;

        String clientDb = request.getParameter(CLIENT_DB);
        if (clientDb != null) {
            request.getSession().setAttribute(CLIENT_DB, clientDb);
            String newUrl = defaultJwksUri.replaceAll("\\?client_name=(.*)", "?client_name=" + clientDb);
            rapClient.addJwksUri(URI.create(newUrl));
        }

        fc.doFilter(req, res);
    }
}
