package it.inaf.ia2.gms.authn;

import it.inaf.ia2.aa.data.User;
import it.inaf.ia2.rap.client.RapClient;
import java.security.Principal;
import javax.servlet.http.HttpServletRequest;

public class ServletRapClient extends RapClient<HttpServletRequest> {

    public ServletRapClient(String baseUrl) {
        super(baseUrl);
    }

    @Override
    protected String getAccessToken(HttpServletRequest request) {
        Principal principal = request.getUserPrincipal();
        if (principal != null) {
            if (principal instanceof User) {
                return ((User) principal).getAccessToken();
            }
            if (principal instanceof RapPrincipal) {
                return ((RapPrincipal) principal).getToken();
            }
        }
        return null;
    }
}
