/*
 * This file is part of gms
 * Copyright (C) 2021 Istituto Nazionale di Astrofisica
 * SPDX-License-Identifier: GPL-3.0-or-later
 */
package it.inaf.ia2.gms.persistence;

import it.inaf.ia2.gms.DataSourceConfig;
import it.inaf.ia2.gms.persistence.model.ActionType;
import javax.servlet.http.HttpServletRequest;
import javax.sql.DataSource;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringRunner;

@RunWith(SpringRunner.class)
@ContextConfiguration(classes = DataSourceConfig.class)
public class LoggingDAOTest {

    @MockBean
    private HttpServletRequest request;

    @Autowired
    private DataSource dataSource;

    private LoggingDAO dao;

    @Before
    public void setUp() {
        dao = new LoggingDAO(dataSource);
    }

    @Test
    public void testLogAction() {
        dao.logAction(ActionType.GROUP_CREATED, "description");
    }

    @Test
    public void testlogException() {
        dao.logException(new RuntimeException("msg"));
    }
}
