/*
 * This file is part of gms
 * Copyright (C) 2021 Istituto Nazionale di Astrofisica
 * SPDX-License-Identifier: GPL-3.0-or-later
 */
package it.inaf.ia2.gms.model;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertTrue;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(JUnit4.class)
public class PermissionTest {

    @Test
    public void addPermissionTest() {

        // Old = null
        assertEquals(Permission.ADMIN, Permission.addPermission(null, Permission.ADMIN));
        assertEquals(Permission.MANAGE_MEMBERS, Permission.addPermission(null, Permission.MANAGE_MEMBERS));
        assertEquals(Permission.VIEW_MEMBERS, Permission.addPermission(null, Permission.VIEW_MEMBERS));
        assertEquals(Permission.TRAVERSE, Permission.addPermission(null, Permission.TRAVERSE));

        // Old = ADMIN -> never change
        assertEquals(Permission.ADMIN, Permission.addPermission(Permission.ADMIN, Permission.VIEW_MEMBERS));
        assertEquals(Permission.ADMIN, Permission.addPermission(Permission.ADMIN, Permission.MANAGE_MEMBERS));
        assertEquals(Permission.ADMIN, Permission.addPermission(Permission.ADMIN, Permission.TRAVERSE));

        // Old = MANAGE_MEMBERS
        assertEquals(Permission.ADMIN, Permission.addPermission(Permission.MANAGE_MEMBERS, Permission.ADMIN));
        assertEquals(Permission.MANAGE_MEMBERS, Permission.addPermission(Permission.MANAGE_MEMBERS, Permission.VIEW_MEMBERS));
        assertEquals(Permission.MANAGE_MEMBERS, Permission.addPermission(Permission.MANAGE_MEMBERS, Permission.TRAVERSE));

        // Old = VIEW_MEMBERS
        assertEquals(Permission.ADMIN, Permission.addPermission(Permission.VIEW_MEMBERS, Permission.ADMIN));
        assertEquals(Permission.MANAGE_MEMBERS, Permission.addPermission(Permission.VIEW_MEMBERS, Permission.MANAGE_MEMBERS));
        assertEquals(Permission.VIEW_MEMBERS, Permission.addPermission(Permission.VIEW_MEMBERS, Permission.TRAVERSE));

        // Old = TRAVERSE
        assertEquals(Permission.ADMIN, Permission.addPermission(Permission.TRAVERSE, Permission.ADMIN));
        assertEquals(Permission.MANAGE_MEMBERS, Permission.addPermission(Permission.TRAVERSE, Permission.MANAGE_MEMBERS));
        assertEquals(Permission.VIEW_MEMBERS, Permission.addPermission(Permission.TRAVERSE, Permission.VIEW_MEMBERS));
    }

    @Test
    public void includesTest() {

        assertTrue(Permission.includes(Permission.ADMIN, Permission.ADMIN));
        assertFalse(Permission.includes(Permission.MANAGE_MEMBERS, Permission.ADMIN));
        assertFalse(Permission.includes(Permission.VIEW_MEMBERS, Permission.ADMIN));
        assertFalse(Permission.includes(Permission.TRAVERSE, Permission.ADMIN));
        assertFalse(Permission.includes(null, Permission.ADMIN));

        assertTrue(Permission.includes(Permission.ADMIN, Permission.MANAGE_MEMBERS));
        assertTrue(Permission.includes(Permission.MANAGE_MEMBERS, Permission.MANAGE_MEMBERS));
        assertFalse(Permission.includes(Permission.VIEW_MEMBERS, Permission.MANAGE_MEMBERS));
        assertFalse(Permission.includes(Permission.TRAVERSE, Permission.MANAGE_MEMBERS));
        assertFalse(Permission.includes(null, Permission.MANAGE_MEMBERS));

        assertTrue(Permission.includes(Permission.ADMIN, Permission.VIEW_MEMBERS));
        assertTrue(Permission.includes(Permission.MANAGE_MEMBERS, Permission.VIEW_MEMBERS));
        assertTrue(Permission.includes(Permission.VIEW_MEMBERS, Permission.VIEW_MEMBERS));
        assertFalse(Permission.includes(Permission.TRAVERSE, Permission.VIEW_MEMBERS));
        assertFalse(Permission.includes(null, Permission.ADMIN));

        assertTrue(Permission.includes(Permission.ADMIN, Permission.TRAVERSE));
        assertTrue(Permission.includes(Permission.MANAGE_MEMBERS, Permission.TRAVERSE));
        assertTrue(Permission.includes(Permission.VIEW_MEMBERS, Permission.TRAVERSE));
        assertTrue(Permission.includes(Permission.TRAVERSE, Permission.TRAVERSE));
        assertFalse(Permission.includes(null, Permission.TRAVERSE));
    }
}
