/*
 * This file is part of gms
 * Copyright (C) 2021 Istituto Nazionale di Astrofisica
 * SPDX-License-Identifier: GPL-3.0-or-later
 */
package it.inaf.ia2.gms.model.response;

import com.fasterxml.jackson.annotation.JsonFormat;
import it.inaf.ia2.gms.model.Permission;
import java.util.Date;

public class InvitedRegistrationItem {

    private String id;
    private String email;
    private Permission permission;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd")
    private Date creationTime;

    public String getId() {
        return id;
    }

    public InvitedRegistrationItem setId(String id) {
        this.id = id;
        return this;
    }

    public String getEmail() {
        return email;
    }

    public InvitedRegistrationItem setEmail(String email) {
        this.email = email;
        return this;
    }

    public Permission getPermission() {
        return permission;
    }

    public InvitedRegistrationItem setPermission(Permission permission) {
        this.permission = permission;
        return this;
    }

    public Date getCreationTime() {
        return creationTime;
    }

    public InvitedRegistrationItem setCreationTime(Date creationTime) {
        this.creationTime = creationTime;
        return this;
    }
}
